local pritok = require 'pritok'

-- Для мнемосхемы:
VAR("AN", "КЛАПАН_ХОЛ")
VAR("AL", "АВАРИЯ_ЧАСТОТНИКА")

--Привязка переменных к входам выходам
BindIn('ПОЛОЖ_ЗАСЛОНКИ', 'RKT-302', 1, 'DI1')
BindIn('ПЕРЕПАД_НА_ФИЛЬТРЕ', 'RKT-302', 1, 'DI2')
BindIn('ПЕРЕПАД_НА_ВЕНТИЛЯТ', 'RKT-302', 1, 'DI3')
BindIn('ПУСК_IO', 'RKT-302', 1, 'DI4')
BindIn('ТЕРМОСТАТ', 'RKT-302', 1, 'DI5')
BindIn('ПУСКАТЕЛЬ_НАСОСА', 'RKT-302', 1, 'DI6')

BindIn('НЗ_Сигнал_пожар', 'RKT-302', 1, 'DI7')

BindIn('Т_обр_воды','RKT-302', 1, 'AI1')
BindIn('Т_притока','RKT-302', 1, 'AI2')
BindIn('Т_нар_воздуха','RKT-302', 1, 'AI3')

BindOut('ВЕНТИЛЯТОР','RKT-302', 1, 'DO1')
BindOut('ЗАСЛОНКА','RKT-302', 1, 'DO2')
BindOut('НАСОС','RKT-302', 1, 'DO3')
BindOut('ЛАМПА','RKT-302', 1, 'DO4')

BindOut('КЛАПАН_ВОДЫ','RKT-302', 1, 'AO1')

--[[
VAR("AN", "ТЕСТ_ФИЛТ_ТРАНС")
-- Трансформация - приведение сигнала 0-10В к давлению  и тд
local x1, x2, y1, y2 = 0, 1000, 100, 200
TransformAI('ТЕСТ_ФИЛТ_ТРАНС', x1, x2, y1, y2)
-- Фильтр на аналоговом входе
FilterAI('ТЕСТ_ФИЛТ_ТРАНС', 10) 
--v['ТЕСТ_ФИЛТ_ТРАНС'] = 5
]]
-- Параметры настройки при наладке
pritok.klapan_progrev = 50
pritok.Klap_min = 6
pritok.G = 1.5
pritok.Ti = 100
pritok.Gw = 5

-- Опрелеление файла панели оператора
set_op('pritok.op')

-- Опрелеление файла мнемсхемы
set_mnemo('pritok_3D.svg')

--[[
-- Начальные значения при отладке без подключения датчиков и ИМ
FilterAI('Т_нар_воздуха', 0)
FilterAI('Т_обр_воды', 0)
FilterAI('Т_притока', 0)
v['Т_нар_воздуха'] = 23
v['Т_обр_воды'] = 23
v['Т_притока'] = 23
v['ПЕРЕПАД_НА_ВЕНТИЛЯТ'] = true
v['ПУСК_IO'] = true
v['ПУСКАТЕЛЬ_НАСОСА'] = true
v['ПОЛОЖ_ЗАСЛОНКИ'] = true
]]

--clear_backups()

function cycle()
    -- Для тестирования входов выходов закомментирвать след. функцию и использовать таблицу переменных
    pritok.pritok_cycle()
end

