VAR('DS', 'ПОЛОЖ_ЗАСЛОНКИ')
VAR('DS', 'ПЕРЕПАД_НА_ФИЛЬТРЕ')
VAR('DS', 'ПЕРЕПАД_НА_ВЕНТИЛЯТ')
VAR('DS', 'ПУСКАТЕЛЬ_НАСОСА')
VAR('DS', 'ТЕРМОСТАТ', {start_value = '1'})
VAR('DS', 'ПУСК_IO')
--779
VAR('DS', 'НЗ_Сигнал_пожар', {start_value = '1'})

VAR('AN', 'Т_нар_воздуха', {time_const = 20})
VAR('AN', 'Т_обр_воды', {time_const = 10})
VAR('AN', 'Т_притока', {time_const = 10})

VAR('DS', 'ВЕНТИЛЯТОР')
VAR('DS', 'НАСОС')
VAR('DS', 'ЗАСЛОНКА')
VAR('DS', 'ЛАМПА') 

VAR('AN', 'КЛАПАН_ВОДЫ')

VAR('AN', 'Уставка_Т_притока', {backup = true, start_value = '22'})

VAR('DS', 'ЗИМА')
VAR('DS', 'Лето')
VAR('DS', 'ПУСК')
VAR('DS', 'ПРОГРЕВ')
VAR('DS', 'ПРОГРЕВ_Ок')
VAR('DS', 'АКТИВНО_РАСПИСАНИЕ')
VAR('DS', 'КРИТИЧЕСКАЯ_АВАРИЯ')

VAR('AN', 'Т_прогрева')
VAR('AN', 'Т_ЗАЩИТЫ_ПО_ВОДЕ')

VAR('DS', 'СБРОС_АВАРИИ')

VAR('DS', 'Зима_принудительно', {backup = true})
VAR('DS', 'ПУСК_МНЕМО', {backup = true})
VAR('DS', 'ПУСК_ПО_РАСПИСАНИЮ', {backup = true})
--[[
VAR('AN', 'КЛАПАН_ПРИ_ПРОГРЕВЕ', {backup = true, start_value = '50'})
VAR('AN', 'Klap_min', {backup = true, start_value = '6'})
VAR('AN', 'G', {backup = true, start_value = '1.5'})
VAR('AN', 'Ti', {backup = true, start_value = '100'})
VAR('AN', 'Gw', {backup = true, start_value = '5'})
]]
-- Критические аварии
VAR('AL', 'АВАРИЯ_ПРОГРЕВА')
VAR('AL', 'АВАРИЯ_НИЗКАЯ_Т_ОБР_ВОДЫ')
VAR('AL', 'АВАРИЯ_СИГНАЛ_ПОЖАР')
VAR('AL', 'АВАРИЯ_ТЕРМОСТАТА')
VAR('AL', 'АВАРИЯ_ВЕНТИЛЯТОРА')
VAR('AL', 'АВАРИЯ_ЗАСЛОНКИ')


-- Не критические аварии
VAR('AL', 'АВАРИЯ_ГРЯЗН_ФИЛЬТР')
VAR('AL', 'АВАРИЯ_КОНТАКТ_НАСОСА')

local function unset_alarms()
	v['АВАРИЯ_ПРОГРЕВА'] = false
	v['АВАРИЯ_НИЗКАЯ_Т_ОБР_ВОДЫ'] = false
	v['АВАРИЯ_СИГНАЛ_ПОЖАР'] = false
	v['АВАРИЯ_ТЕРМОСТАТА'] = false
	v['АВАРИЯ_ВЕНТИЛЯТОРА'] = false
	v['АВАРИЯ_ЗАСЛОНКИ'] = false
	v['КРИТИЧЕСКАЯ_АВАРИЯ'] = false
end

local pritok = {}
pritok.klapan_progrev = 50
pritok.Klap_min = 6
pritok.G = 1.5
pritok.Ti = 100
pritok.Gw = 5

local prev_io_run = false

function pritok.pritok_cycle()

	-- Переключение зима/лето
	v['ЗИМА'] = v['Зима_принудительно'] or 
	    not hyst(v['Т_нар_воздуха'], 8, 12, 'Гистерезис Зима-Лето')
	
	v['Лето'] = not v['ЗИМА']
	
	-- Насос
	v['НАСОС'] = v['ЗИМА'] 
	---------------------------------------------------------------------------
	-- Сброс аварий
	-- Ждем сброса аварий из браузера
	if v['СБРОС_АВАРИИ'] then
		unset_alarms() 
		v['СБРОС_АВАРИИ'] = false
	end

	-- Смена состояния переключателя - сброс аварий
	if v['ПУСК_IO'] ~= prev_io_run then
		if v['КРИТИЧЕСКАЯ_АВАРИЯ'] then
			-- Есть активные аварии
			unset_alarms()
		end
	end
	prev_io_run = v['ПУСК_IO']
	---------------------------------------------------------------------------
	-- Обработка сигнала Пожар. Инверсный
	if not v['НЗ_Сигнал_пожар'] then
		v['АВАРИЯ_СИГНАЛ_ПОЖАР'] = true
		v['КРИТИЧЕСКАЯ_АВАРИЯ'] = true
	end
	---------------------------------------------------------------------------
	-- Термостат защиты от замораживания.Инверсный
	if not v['ТЕРМОСТАТ'] then
		v['АВАРИЯ_ТЕРМОСТАТА'] = true
		v['КРИТИЧЕСКАЯ_АВАРИЯ'] = true
	end 
	---------------------------------------------------------------------------
	-- Получаем уставку защиты. Уставка аварии обратной воды
	-- График преобразования наружной температуры в уставку защиты по воде
	local sp_water_alarm = curve(v['Т_нар_воздуха'], -26, 16, 5, 8, true)
	
	v['Т_ЗАЩИТЫ_ПО_ВОДЕ'] = sp_water_alarm
	
	-- Контроль аварии обратной воды
	if v['ЗИМА'] then -- Только Зимой
		-- Температура обратной воды
		if v['Т_обр_воды'] < sp_water_alarm then
			v['АВАРИЯ_НИЗКАЯ_Т_ОБР_ВОДЫ'] = true
			v['КРИТИЧЕСКАЯ_АВАРИЯ'] = true
		end
	end
	---------------------------------------------------------------------------
	-- Формирование сигнала Пуск
	-- Пуск из браузера  AND  дискретный вход.
	local run = v['ПУСК_МНЕМО'] and v['ПУСК_IO']

	-- Отслеживание недельного расписания
	v['АКТИВНО_РАСПИСАНИЕ'] = tsch()

	-- Если включается сигнал «Работа по расписанию» из браузера, то пуска не будет без активного расписания.
	if v['ПУСК_ПО_РАСПИСАНИЮ'] then
		if not v['АКТИВНО_РАСПИСАНИЕ'] then
			run = false
		end
	end

	-- Критическая авария не разрешает пуск
	if v['КРИТИЧЕСКАЯ_АВАРИЯ'] then
		run = false
	end

	v['ПУСК'] = run
	---------------------------------------------------------------------------
	progrev() -- In: ЗИМА,ПУСК; Out: ПРОГРЕВ, ПРОГРЕВ_Ок, АВАРИЯ_ПРОГРЕВА
	---------------------------------------------------------------------------
	-- Запуск вентилятора
	if v['ЗИМА'] then
		-- Если Зима, то после прогрева
		v['ВЕНТИЛЯТОР'] = v['ПУСК'] and v['ПРОГРЕВ_Ок']
	else
		-- Если   Лето, то  сразу запуск
		v['ВЕНТИЛЯТОР'] = v['ПУСК']
	end
	---------------------------------------------------------------------------
	-- Контроль работы вентилятора
	local run_fan_delay = delay(v['ВЕНТИЛЯТОР'], 10, 0, 'Задержка для контроля перепада')

	if run_fan_delay and (not v['ПЕРЕПАД_НА_ВЕНТИЛЯТ']) then
		v['АВАРИЯ_ВЕНТИЛЯТОРА'] = true
		v['КРИТИЧЕСКАЯ_АВАРИЯ'] = true
	end
	---------------------------------------------------------------------------
	-- Открытие заслонки
	v['ЗАСЛОНКА'] = v['ВЕНТИЛЯТОР']
	---------------------------------------------------------------------------
	-- Контроль открытия заслонки
	local run_zasl_fan_delay = delay(v['ВЕНТИЛЯТОР'], 180, 0, 
	    'Задержка контроля открытия заслонки')
	if run_zasl_fan_delay and (not v['ПОЛОЖ_ЗАСЛОНКИ']) then
	    v['АВАРИЯ_ЗАСЛОНКИ'] = true
		v['КРИТИЧЕСКАЯ_АВАРИЯ'] = true
	end
	---------------------------------------------------------------------------
	-- Фильтр
	-- грязный фильтр
	local filter_delay = delay(v['ПЕРЕПАД_НА_ФИЛЬТРЕ'], 10, 0, 'Задержка для контроля фильтра')
	v['АВАРИЯ_ГРЯЗН_ФИЛЬТР'] = filter_delay
	---------------------------------------------------------------------------
	-- Лампочка аварии
	-- Лампа загорается если критическая  авария или  грязный фильтр
	v['ЛАМПА'] = v['КРИТИЧЕСКАЯ_АВАРИЯ'] or v['АВАРИЯ_ГРЯЗН_ФИЛЬТР']
	---------------------------------------------------------------------------
	-- Контроль пускателя насоса
	local run_pump_delay = delay(v['НАСОС'], 3, 0, 'Задержка контроля пускателя насоса')
	v['АВАРИЯ_КОНТАКТ_НАСОСА'] = run_pump_delay 
	    and (not v['ПУСКАТЕЛЬ_НАСОСА'])
	---------------------------------------------------------------------------
	valve_control(sp_water_alarm) --In: ЗИМА, ПРОГРЕВ,ПУСК, АВАРИЯ_КОНТАКТ_НАСОСА

end

----------------------------------------------------------------------------------------------
-- При аварийном снижении температуры воды до некоторого значения (вычисляется по графику защиты) срабатывает защита,
-- система выходит на аварию НИЗКАЯ Т ВОДЫ, приточная установка останавливается и блокируется.
-- В начальный момент клапан открывается на 100% для поднятия температуры и далее поддерживает температуру по графику обратной воды.
----------------------------------------------------------------------------------------------
-- ПИД по воздуху
----------------------------------------------------------------------------------------------
local pid_air = {
	--ПАРАМЕТРЫ, задаются при вызове функции pida
	--mode = 1, 				-- Рабочий режим регулятора.
	--G = 1.5,  				-- Пропорциональное усиление.2
	--Ti = 100, 				-- Время интегрирования (сек).
	--ПАРАМЕТРЫ
	Td = 0, -- Время дифференцирования (сек).
	dz = 0.01, -- Мертвая зона.
	control_int = 1, -- Интервал управления (сек).
	umin = 0, -- Минимальновозможный управляющий сигнал.
	umax = 100, -- Максимальновозможный управляющий сигнал.
	stroke_time = 40 -- Время полного хода штока привода (сек)
}

----------------------------------------------------------------------------------------------
-- ПИД по воде при работе
----------------------------------------------------------------------------------------------
local pid_water_on = {
	--ПАРАМЕТРЫ, задаются при вызове функции pida
	--mode = 1, 				-- Рабочий режим регулятора.
	--G = 5,  				-- Пропорциональное усиление.
	--Ti = 100, 				-- Время интегрирования (сек).
	--ПАРАМЕТРЫ
	Td = 0, -- Время дифференцирования (сек).
	dz = 0.01, -- Мертвая зона.
	control_int = 1, -- Интервал управления (сек).
	umin = 0, -- Минимальновозможный управляющий сигнал.
	umax = 100, -- Максимальновозможный управляющий сигнал.
	stroke_time = 40 -- Время полного хода штока привода (сек)
}

----------------------------------------------------------------------------------------------
-- ПИД по воде при стоп
----------------------------------------------------------------------------------------------
local pid_water_off = {
	--ПАРАМЕТРЫ, задаются при вызове функции pida
	--mode = 1, 				-- Рабочий режим регулятора.
	--G = 5,  				-- Пропорциональное усиление.
	--Ti = 100, 				-- Время интегрирования (сек).

	--ПАРАМЕТРЫ
	Td = 0, -- Время дифференцирования (сек).
	dz = 0.1, -- Мертвая зона.
	control_int = 1, -- Интервал управления (сек).
	umin = 0, -- Минимальновозможный управляющий сигнал.
	umax = 100, -- Максимальновозможный управляющий сигнал.
	stroke_time = 40 -- Время полного хода штока привода (сек)
}

--------------------------------------------------------------------------------------
-- Управление рег. клапаном по теплу
--------------------------------------------------------------------------------------

function valve_control(sp_water_alarm)
	--Термостат(false - авария)   — открытие клапана на 100%.
	-- После того как термостат вернулся в true, держим еще 60 секунд
	local termostat_delay60 = delay(not v['ТЕРМОСТАТ'], 0, 60, 'термостат 60 секунд')
	if termostat_delay60 then
		v['КЛАПАН_ВОДЫ'] = 100
		return
	end

	-- Если   Лето закрываем клапан
	if not v['ЗИМА'] then
		v['КЛАПАН_ВОДЫ'] = 0
		return
	end
	-- Далее зима

	-- Если прогрев открываем клапан
	if (v['ПРОГРЕВ']) then
		v['КЛАПАН_ВОДЫ'] = pritok.klapan_progrev
		return
	end

	-- Температура обратной воды
	local t_water = v['Т_обр_воды']

	-- При достижении  уставки защиты по воде+ 2 градуса — открытие клапана на 100%.
	if t_water < (sp_water_alarm + 2) then
		-- Откроем клапан на 100%
		v['КЛАПАН_ВОДЫ'] = 100
		return
	end

	local pred_valve = v['КЛАПАН_ВОДЫ']

	-- Если  Пуск то работают ПИДы pid_air и pid_water_on
	local valve = 0
	if v['ПУСК'] then
		-- Работа
		-- Расчитываем PID по воде
		local sp_water = sp_water_alarm + 4
		valve = pida(pid_water_on, t_water, sp_water, pred_valve, 1, pritok.Gw, pritok.Ti)

		-- Расчитываем PID по воздуху
		local valve_air = pida(pid_air, v['Т_притока'], v['Уставка_Т_притока'], pred_valve, 1, pritok.G, pritok.Ti)

		-- Выбераем максимум между воздухом и водой
		valve = math.max(valve_air, valve)

		-- Минимальное значение клапана
		valve = math.max(pritok.Klap_min, valve)
	else
		-- Стоп Зима
		-- Расчитываем PID по воде
		local sp_water = 35
		valve = pida(pid_water_off, t_water, sp_water, pred_valve, 1, pritok.Gw, pritok.Ti)
	end
	-- Если авария насоса клапан не закрываем на 10%
	if v['АВАРИЯ_КОНТАКТ_НАСОСА'] then
		valve = math.max(10, valve)
	end
	v['КЛАПАН_ВОДЫ'] = valve
end

--------------------------------------------------------------------------------------
-- Прогрев т/о перед  пуском зимой
--------------------------------------------------------------------------------------

function progrev()
	-- ПРОГРЕВ_Ок - сигнал = true: прогрев успешно выполнен,
	-- и разрешается запустить вентилятор зимой.

	-- Если   Лето или Стоп сбрасываем прогрев (прогрева не было)
	if (not v['ЗИМА']) or (not v['ПУСК']) then
		v['ПРОГРЕВ_Ок'] = false
	end

	-- ПРОГРЕВ - сигнал = true прогрев выполняется: Пуск,Зима,Прогрева не было.
	v['ПРОГРЕВ'] = v['ЗИМА'] and v['ПУСК'] and (not v['ПРОГРЕВ_Ок'])

	local progrev_alarm_delay = delay(v['ПРОГРЕВ'], 600, 0, 'progrev_alarm_delay станет true через 600 сек после ПРОГРЕВ')

	local progrev_delay10 = delay(v['ПРОГРЕВ'], 10, 0, 'Задержка на 10 секунд - минимальное время прогрева')

	-- Прогрев завершен
	if v['ПРОГРЕВ_Ок'] then
		return
	end

	if progrev_alarm_delay then
		-- Не удачный прогрев, больше 600 секунд
		v['АВАРИЯ_ПРОГРЕВА'] = true
		v['КРИТИЧЕСКАЯ_АВАРИЯ'] = true
	end

	-- График прогрева
	if v['ПРОГРЕВ'] then
		-- Температура прогрева
		local t_progr = curve(v['Т_нар_воздуха'], -25, 70, 6, 36, true)

		-- Температуру прогрева на мнемосхему
		v['Т_прогрева'] = t_progr

		-- 10 секунд обязательный прогрев, после 10 секунд проверяем
		if (v['Т_обр_воды'] >= t_progr) and progrev_delay10 then
			-- Удачный прогрев
			v['ПРОГРЕВ_Ок'] = true
		end
	end
end

return pritok
