-- Danfoss VLT FC 51
local modbus = require("libmodbus")

VAR('DS', 'FC51_ПУСК')
VAR('AN', 'FC51_СКОРОСТЬ_0_100')
VAR('DS', 'FC51_АВАРИЯ')
VAR('DS', 'FC51_НЕТ_СВЯЗИ')

function add_run(ctx)
    -- Установка адреса устройства (адрес преобразователя частоты)
    local slave_address = 4
    ctx:set_slave(slave_address)

    -- ПУСК / СТОП + СКОРОСТЬ
    fc51_set_run_and_speed(ctx)
    wait_from_net_and_sleep(100)

    -- ЧТЕНИЕ СИГНАЛА АВАРИИ
    fc51_get_alarm(ctx)
    wait_from_net_and_sleep(100)
end

-- Закрытие соединения
-- modbus.close(ctx)
-- rkt_log("Опрос завершен")

-- start: boolean (true = пуск, false = стоп)
-- percent: 0..100
function fc51_set_run_and_speed(ctx)
    rkt_log("ПУСК / СТОП + СКОРОСТЬ")
    local percent = v['FC51_СКОРОСТЬ_0_100']
    if percent < 0 then
        percent = 0
    end
    if percent > 100 then
        percent = 100
    end

    local bits = {}

    -- --- 1–16: командное слово ---
    for i = 1, 16 do
        bits[i] = false
    end

    bits[11] = true -- Data valid (обязательно)

    local start = v['FC51_ПУСК']
    if start then
        bits[7] = true  -- ПУСК
    else
        bits[7] = false -- СТОП
    end

    -- --- 17–32: задание скорости ---
    local value = math.floor(percent * 0x8000 / 100 + 0.5)

    for i = 1, 16 do
        bits[16 + i] = (value & (1 << (i - 1))) ~= 0
    end

    -- одна Modbus-команда
    local result, err = ctx:write_bits(0, bits)
    check_result(result, err)
end

-- ЧТЕНИЕ СИГНАЛА АВАРИИ
-- Слово состояния (катушка 36, адрес 35 в 0-based)
-- Бит 36: 0 = нет аварии, 1 = аварийный сигнал
function fc51_get_alarm(ctx)
    rkt_log("ЧТЕНИЕ СИГНАЛА АВАРИИ")
    local status_coil_address = 35

    local result, err = ctx:read_bits(status_coil_address, 1)
    check_result(result, err)
    if result then
        local alarm_status = result[1]
        if alarm_status == 1 then
            rkt_log("АВАРИЙНЫЙ СИГНАЛ: преобразователь в аварии")
            v['FC51_АВАРИЯ'] = true
        else
            rkt_log("Аварийных сигналов нет")
            v['FC51_АВАРИЯ'] = false
        end
    end
end

function check_result(result, err)
    if result then
        v['FC51_НЕТ_СВЯЗИ'] = false
    else
        rkt_log("FC51_НЕТ_СВЯЗИ: " .. tostring(err))
        v['FC51_НЕТ_СВЯЗИ'] = true
    end
end
